/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman;

import filenet.vw.apps.taskman.VWScopeTreeMouseAndKeyAdapter;
import filenet.vw.apps.taskman.VWTaskBaseNode;
import filenet.vw.apps.taskman.VWTaskContentEvent;
import filenet.vw.apps.taskman.VWTaskContentListener;
import filenet.vw.apps.taskman.VWTaskRootNode;
import filenet.vw.apps.taskman.VWTaskScopeTree;
import filenet.vw.apps.taskman.VWTaskTreeCellRender;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class VWTaskScopePane
extends JScrollPane
implements TreeSelectionListener,
TreeModelListener,
ActionListener,
VWTaskContentListener {
    private Container m_parentContainer = null;
    private Frame m_parentFrame = null;
    private VWTaskScopeTree m_scopeTree = null;
    private VWScopeTreeMouseAndKeyAdapter m_scopeTreeMouseAdapter = null;
    private VWTaskRootNode m_root = null;
    private EventListenerList m_listenerList = null;

    public VWTaskScopePane() {
        this.setDoubleBuffered(true);
        Dimension dim = VWStringUtils.stringToDimension("0,0");
        if (dim == null) {
            dim = new Dimension(0, 0);
        }
        this.setSize(dim.width, dim.height);
        this.m_listenerList = new EventListenerList();
        this.setHorizontalScrollBarPolicy(30);
        this.setVerticalScrollBarPolicy(20);
        this.setMinimumSize(new Dimension(0, 0));
        dim = VWStringUtils.stringToDimension("225,775");
        if (dim == null) {
            dim = new Dimension(200, 700);
        }
        this.setPreferredSize(dim);
    }

    public void init(TreeModel treeModel, Container parentContainer, Frame parentFrame) {
        this.m_parentContainer = parentContainer;
        this.m_parentFrame = parentFrame;
        this.m_root = (VWTaskRootNode)treeModel.getRoot();
        this.m_scopeTree = new VWTaskScopeTree(treeModel, this);
        this.m_scopeTree.getSelectionModel().setSelectionMode(1);
        this.m_scopeTree.addTreeSelectionListener(this);
        this.m_scopeTree.setCellRenderer(new VWTaskTreeCellRender(this));
        this.m_scopeTreeMouseAdapter = new VWScopeTreeMouseAndKeyAdapter(this.m_scopeTree);
        this.m_scopeTree.addMouseListener(this.m_scopeTreeMouseAdapter);
        this.m_scopeTree.addKeyListener(this.m_scopeTreeMouseAdapter);
        treeModel.addTreeModelListener(this);
        this.expandScopeTree(this.m_root);
        this.getViewport().add(this.m_scopeTree);
    }

    public JTree getTree() {
        return this.m_scopeTree;
    }

    public void moveFocusUp() {
        if (this.m_scopeTree.getFocus().getParent() != null) {
            this.setFocus((VWTaskBaseNode)this.m_scopeTree.getFocus().getParent());
        }
    }

    public void addActionListener(ActionListener al) {
        this.m_listenerList.add(ActionListener.class, al);
    }

    public void removeActionListener(ActionListener al) {
        this.m_listenerList.remove(ActionListener.class, al);
    }

    public void valueChanged(TreeSelectionEvent event) {
        TreePath path = event.getNewLeadSelectionPath();
        if (path != null) {
            VWTaskBaseNode node = (VWTaskBaseNode)path.getLastPathComponent();
            this.m_scopeTree.setFocus(node);
            this.m_scopeTree.setHasApplicationFocus(true);
            this.m_scopeTree.invalidate();
            this.m_scopeTree.validate();
            this.m_scopeTree.repaint();
        }
    }

    public void treeNodesRemoved(TreeModelEvent event) {
        Object[] path;
        Object selectedNode = null;
        boolean deletedNodeSelected = false;
        TreePath selectionPath = this.m_scopeTree.getSelectionPath();
        if (selectionPath != null) {
            selectedNode = selectionPath.getLastPathComponent();
            Object[] children = event.getChildren();
            if (children != null && selectedNode != null) {
                for (int i = 0; i < children.length; ++i) {
                    if (!children[i].equals(selectedNode)) continue;
                    deletedNodeSelected = true;
                }
            }
        }
        if ((path = event.getPath()) != null && (deletedNodeSelected || selectedNode == null)) {
            VWTaskBaseNode parentNode = (VWTaskBaseNode)new TreePath(path).getLastPathComponent();
            this.setFocus(parentNode);
        }
    }

    public void treeNodesInserted(TreeModelEvent event) {
    }

    public void treeNodesChanged(TreeModelEvent event) {
    }

    public void treeStructureChanged(TreeModelEvent event) {
    }

    public void actionPerformed(ActionEvent event) {
        this.fireActionEvent(event);
    }

    public void taskContentChanged(VWTaskContentEvent evt) {
        VWTaskBaseNode baseNode = evt.getBaseNode();
        try {
            if (evt.getAction() == 1) {
                this.setFocus(baseNode);
            } else if (evt.getAction() == 2) {
                this.m_scopeTree.setHasApplicationFocus(false);
                this.m_scopeTree.invalidate();
                this.m_scopeTree.validate();
                this.m_scopeTree.repaint();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected boolean hasApplicationFocus() {
        return this.m_scopeTree.hasApplicationFocus();
    }

    protected VWTaskBaseNode getFocus() {
        return this.m_scopeTree.getFocus();
    }

    protected void collapsePath(VWTaskBaseNode aNode) {
        TreePath treePath = new TreePath(aNode.getPath());
        this.m_scopeTree.collapsePath(treePath);
    }

    protected void expandScopeTree(VWTaskBaseNode aNode, boolean setFocus) {
        TreePath treePath = new TreePath(aNode.getPath());
        if (setFocus) {
            this.setFocus(aNode);
        }
        this.m_scopeTree.expandPath(treePath);
    }

    protected void expandScopeTree(VWTaskBaseNode aNode) {
        this.expandScopeTree(aNode, true);
    }

    protected void setFocus(VWTaskBaseNode node) {
        TreePath treePath = new TreePath(node.getPath());
        this.m_scopeTree.setSelectionPath(treePath);
        this.m_scopeTree.scrollPathToVisible(treePath);
    }

    private void fireActionEvent(ActionEvent event) {
        if (event == null) {
            return;
        }
        Object[] listeners = this.m_listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ActionListener.class) continue;
            ((ActionListener)listeners[i + 1]).actionPerformed(event);
        }
    }
}

